---
layout:     post
title:      「体能训练理论」之金字塔
subtitle:   「健身先健脑」科学的运动需要科学的运动理论
date:       2017-07-10
author:     BY
header-img: img/post-bg-mma-2.jpg
catalog: true
tags:
    - 健身
    - 生活
---


## 引言

体能，人体基础运动能力的统称，人体的本质属性，它支撑着日常生活工作的需要，也支撑着运动技战术的表现。 体能思路，是指导我们设计实施体能训练的思维方式，分析逻辑。它包括回归原点的 **五大运动素质** & [**动力链理论**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E5%8A%A8%E5%8A%9B%E9%93%BE/)，也包括在过程中引领方向的 [**功能性原则**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E5%8A%9F%E8%83%BD%E6%80%A7/) 和 [**金字塔**](http://qiubaiying.top/2017/07/10/%E4%BD%93%E8%83%BD%E8%AE%AD%E7%BB%83%E7%90%86%E8%AE%BA-%E4%B9%8B%E9%87%91%E5%AD%97%E5%A1%94/) 。

## 金字塔

体能训练是一门实践科学，实践先于理论，而理论印证实践。体能训练有四大基础学科，分别是运动解剖学、运动生理学、运动生物力学和运动训练学。

五大运动素质对应生理学和运动训练学；动力链对应解剖学和运动生物力学；功能性对应着生理和生物力。而金字塔则对应了它们全部！或者说金字塔其实是诸学科在体能训练中的交汇，它囊括了所有之前的理论，并且赋予了更深层的意义。

![](https://ws4.sinaimg.cn/large/006tKfTcgy1fhg20ydk8uj30go0brwh1.jpg)

金字塔代表了人体运动能力发展的客观规律，它是一个流程的引领，思维的分级，以及训练阶段的划分。

这里包括 **关节功能+核心控制**、**基础动作模式**、**基础力量**、**综合体能**、**专项运动**。他们在逻辑上互为基础和进阶，关节是动作的基础，动作承载力量，力量支撑各个运动素质，而专项是各个运动素质在具体运动中的表现。

也许这么说可能不能够让大家有清晰的认识，那么接下来我就把每层的内容和它们之间的逻辑关系简单的跟大家分享一下。 99%的运动者都是基础不足，上层过度。我们从基础开始，从下往上说起。

### 运动基础（关节功能 + 核心控制）

运动基础主要内容包括 **关节功能** 和 **核心控制** 能力。

人体的关节功能有两个属性，一个是灵活性，一个是稳定性。举例来说，很多人由于长期缺乏锻炼，肩关节灵活性缺失，第一次学习竖直上举时，怎么努力都举不到头顶，显然应该先改善肩关节灵活性。再比如，膝关节的结构导致它只能进行屈伸的运动，所以我们要保证运动过程中不出现膝内扣，膝外翻的现象，也就是膝关节需要具备的稳定能力。在健身之前我们，应该先评估我们的关节功能。

运动基础中的第二部分内容就是核心控制能力。很多健身者入门者都会觉得核心是腹肌，觉得练核心的目的是拥有一个好看的腹肌。实际上，腹肌只是核心的一部分，核心是指一个区域，我们的整个躯干都属于核心区域。

运动的外在表现虽来源于四肢，比如跑步时你的四肢在运动，但是一个出色的外在运动表现是建立在稳定的核心基础之上的。如果躯干不稳定，在跑步的过程中整个脊柱很松散，甩来甩去，这样是很难提高跑步速度的。所以在学习动作之前，应该先加强核心控制能力。

所以我们会推荐没有进行过抗阻训练、长期久坐的同学先去练习一段时间的瑜伽和普拉提，瑜伽可以很好地改善关节灵活性，进而提高身体的柔韧性；而普拉提能提高的核心控制能力，并提高关节稳定性。
一个合格的健身训练者，应该了解不同的训练体系，他要知道自身还缺乏什么，然后向不同的训练体系去借鉴，以提高自己。

### 基础动作模式

#### 什么是基础动作模式？

简单地说就是，所有动作肢体特有的运动程序。人体就这么些零件，所以很多的动作之间都存在着些许的共性，我们将这些共性提炼出来并进行功能上的抽象，那么就形成了我们现在所要说的基础动作模式——**双腿蹲**、**单腿蹲**、**推**、**拉**、**旋转**、**屈髋**。

- **蹲**：分为单腿蹲、双腿蹲。对应的训练动作有剪蹲和深蹲。
- **推**：分为水平推、竖直推。对应的训练动作是卧推和实力举。
- **拉**：分为竖直拉、水平拉。竖直拉包括引体向上、高位下拉，水平拉包括弹力带划船等等。
- **屈髋**：最具代表性的动作就是硬拉。
- **旋转**：动作比较复杂，在训练当中比较少出现，适合比较资深的训练者，比如说劈和砍，比如下劈球，比如拿锤子砸轮胎。前期不建议做，当你有一定训练水平的时候再去做旋转类动作。

![](https://ws4.sinaimg.cn/large/006tKfTcgy1fhg20yeticj30go0ptdmg.jpg)

#### 基础动作模式的意义是什么？

1. 教会我们如何正确的使用我们的身体
2. 评估你的是否存在关节功能缺陷

基于基础动作模式的学习意义和诊断意义，我们对待健身者或者需要进行体能训练的人很多时候都从这里开始。如果诊断结果良好，那么我们学习动作之后就可以上升到基础力量训练，如果诊断出关节功能缺陷，我们就要进行针对性的解决。


### 基础力量（肌肉力量）

力量是所有运动素质的基础，如果你没有足够的力量，很多事情都很难完成。你想学习倒立，如果上肢力量足够，只需要了解动作技巧和细节，可能半个小时就能学会倒立。但是如果力量水平很低，就算把各种技巧和细节都学会了，也没有力气把自身撑起来，更不可能完成倒立。日常生活中，力量水平不足经常会成为我们突破运动瓶颈的障碍，有足够的力量才能跑得更快、跑得更远、跳得更高。所以，力量是所有运动素质的基础。

因此，在金字塔的这层，我们就要从徒手训练的阶段进阶到自由力量训练的阶段。负重和徒手的训练效果差异非常大，它不仅仅在于力量的提高，在重心控制、身体平衡、协调性控制等方面的区别也很大。力量训练能让身体各项能力同时提高，只有真正进入力量训练阶段（对于健身来说），才可以说真正踏上健身入门之路。

### 训练目标（综合体能和专项体能）

最后，我们来到了金字塔的顶端，这就是我们的最终追求。

综合体能在此指的是体能所包含的五大运动素质——力量，速度，灵敏，耐力，柔韧。对于有专项运动需求的人，我们需要有针对性的重点发展这五大运功素质中的某几个。

当我们身体各关节灵活性和稳定性都可以满足要求，且核心控制能力也很强的情况下，又在标准动作的基础上储备了足够的肌肉力量，那么，不管你的目标是减肥，增肌，或者是进行某一个竞技性运动项目，你都可以相对安全且轻松地达成你的目标。

一般我们把还处在第一第二层的健身者称为健身入门者。不管你是刚刚走进健身房的新手，还是健身多年的老司机，都可以根据这个健身发展流程来审视自己目前的训练处在哪一个阶段。

## 总结

体能训练金字塔告诉我们，体能训练要从关节功能和核心控制开始训练，通过六大基础运动模式的训练增强身体基础力量，只有基础力量够了，我们才能真正开始我们的训练目标，根据我们训练的项目增强专项体能，比如拳击，我们要增强力量，耐力，灵敏。

清楚了这个体能训练金字塔之后，更重要的事还是要去执行。执行层面会涉及更多技术问题，也就是我们常说的如何做标准的动作，如何制定适合自己的训练计划等等。

健身是一项系统性工程，愿每一个人都能找到方法，科学有效地塑造自己的身体。

>参考 

>- [《体能训练之金字塔》](https://zhuanlan.zhihu.com/p/20801623)
>- [零基础健身者的运动发展流程](http://www.jianshenjiaolian.com.cn/lingjichu-fazhan.html)